function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 121);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(50));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(45));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(42));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(43))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(50))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(50))*(1-params(11))*params(3);
T(19) = exp(y(13))^(params(3)-1);
T(20) = exp(y(44));
T(21) = exp(y(51))*exp(y(30));
T(22) = exp(y(52))*exp(y(29));
T(23) = params(6)*exp(y(53))*exp(params(5)*(y(10)-y(62)))*exp(y(6));
T(24) = params(9)^((-1)/params(8));
T(25) = 1/params(8);
T(26) = exp(y(49));
T(27) = exp(y(46))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(28) = T(27)^(-params(14));
T(29) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(30) = T(29)^(-params(14));
T(31) = params(13)^(1-params(4));
T(32) = exp(y(111))*params(6)*params(5)*exp(y(113))*exp(y(38)*(params(5)-1));
T(33) = params(12)^(1-params(4));
T(34) = T(28)*exp(y(28))*exp(y(31));
T(35) = params(30)^(-1);
T(36) = T(35)*y(21)*(-(T(26)*exp(y(28))*exp(y(11))));
T(37) = exp(y(28))*y(64)+T(36)+T(35)*y(23)*(-(exp(y(28))*T(26)));
T(38) = T(21)*y(68);
T(39) = exp(y(61)-y(62));
T(40) = exp(y(31))*exp(y(54))*params(6)*T(39)^(params(5)-1);
T(41) = exp(y(28))*exp(y(31))-T(40);
T(42) = params(30)*y(119)*exp(y(33))*params(6)*exp(y(113))*exp(params(5)*(y(37)-y(114)));
T(43) = params(30)*y(126)*(-(exp(y(33))*exp((-y(114)))*exp(y(37))));
T(44) = exp(y(33))*y(76)+T(42)+params(30)*y(122)*(-(exp(y(33))*(1-exp((-y(114)))*exp(y(37)))))+T(43);
T(45) = params(30)*y(125)*(-(exp(y(38))*exp(y(34))));
T(46) = exp(y(34))*y(75)+params(30)*y(119)*exp(y(34))*params(6)*exp(params(5)*y(38))+params(30)*y(121)*(-((1-exp(y(38)))*exp(y(34))))+T(45);
T(47) = exp(y(35))*y(78)+y(76)*(-(params(7)*exp(y(35))))+params(30)*y(124)*(-((1-params(7))*exp(y(35))));
T(48) = exp(y(36))*y(77)+y(75)*(-(params(7)*exp(y(36))))+params(30)*y(123)*(-((1-params(7))*exp(y(36))));
T(49) = params(30)*y(119)*exp(y(33))*params(6)*exp(y(113))*params(5)*exp(params(5)*(y(37)-y(114)));
T(50) = params(30)*y(122)*(-(exp(y(33))*(-(exp((-y(114)))*exp(y(37))))));
T(51) = T(43)+T(49)+T(50);
T(52) = exp(y(111))*params(6)*params(5)*exp(y(113))*(params(5)-1)*exp(y(38)*(params(5)-1));
T(53) = y(74)*T(52);
T(54) = (-(exp(y(111))*(exp(y(38))*exp(y(103))+y(104)*(-exp(y(38)))-params(6)*exp(y(113))*params(5)*exp(params(5)*y(38)))));
T(55) = y(71)*T(54);
T(56) = params(30)*y(121)*(-(exp(y(34))*(-exp(y(38)))));
T(57) = T(8)*getPowerDeriv(T(8),T(13),1);
T(58) = T(8)*getPowerDeriv(T(8),T(1),1);
T(59) = getPowerDeriv(T(9),T(10),1);
T(60) = exp(y(43))*getPowerDeriv(exp(y(43)),T(11),1);
T(61) = exp(T(1)*y(50))*(1-params(11))*params(3)*T(60);
T(62) = exp(T(1)*y(50))*(1-params(11))*(1-params(3))*T(60);
T(63) = (1-params(11))*exp(T(1)*y(112));
T(64) = exp(y(108))^(1-params(3));
T(65) = T(20)*getPowerDeriv(T(20),params(3),1);
T(66) = T(20)^params(3);
T(67) = T(64)*T(66);
T(68) = getPowerDeriv(T(67),T(1),1);
T(69) = T(63)*T(64)*T(65)*T(68);
T(70) = T(67)^T(1);
T(71) = T(63)*T(70)+params(11)*exp(y(106))^T(1);
T(72) = getPowerDeriv(T(71),T(10),1);
T(73) = exp(y(108))^(-params(3));
T(74) = exp(y(107))^T(11);
T(75) = T(74)*(1-params(11))*(1-params(3))*exp(T(1)*y(112));
T(76) = T(67)^T(13);
T(77) = getPowerDeriv(T(67),T(13),1);
T(78) = T(64)*T(65)*T(77);
T(79) = T(20)^(params(3)-1);
T(80) = T(74)*(1-params(11))*params(3)*exp(T(1)*y(112));
T(81) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(82) = (-(T(64)*(T(79)*T(78)*T(80)+T(76)*T(80)*T(81))));
T(83) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(84) = (-(params(9)*T(83)/(1+params(8))));
T(85) = getPowerDeriv(T(27),(-params(14)),1);
T(86) = T(84)*T(85);
T(87) = (1-params(3))*exp(y(45)*(1-params(3)));
T(88) = (-(exp(T(1)*y(50))*exp(y(13)*params(3))*T(87)));
T(89) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(90) = getPowerDeriv(T(6),T(13),1);
T(91) = T(3)*T(89)*T(90);
T(92) = (-(T(16)*T(18)*T(19)*T(89)+T(5)*T(19)*T(18)*T(91)));
T(93) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(94) = (-(T(17)*T(3)*T(15)*T(91)+T(3)*T(15)*T(16)*T(93)));
T(95) = getPowerDeriv(T(6),T(1),1);
T(96) = T(2)*T(3)*T(89)*T(95);
T(97) = exp(y(109))-params(9)*exp(y(108))^(1+params(8))/(1+params(8));
T(98) = params(1)*T(97)^(-params(14));
T(99) = exp(y(46))*T(85);
T(100) = (-(params(1)*T(99)/T(30)));
T(101) = T(35)*y(20)*(-(exp(y(47))*T(26)));
T(102) = exp(y(48))*getPowerDeriv(exp(y(48)),T(25),1);
T(103) = (-(T(26)*(exp(y(28))*exp(y(11))+y(40)*(1-exp(y(11)))-exp(params(5)*y(11))*params(6)*exp(y(53)))));
T(104) = T(35)*y(23)*(T(26)*params(6)*params(5)*exp(y(53))*exp(y(11)*(params(5)-1))-T(26)*(exp(y(28))-y(40)))+T(26)*y(70)+T(35)*y(20)*(-(T(26)*(1+exp(y(47))-params(10))))+T(35)*y(21)*T(103)+T(35)*y(22)*(-(y(41)*T(26)*(1-params(7))));
T(105) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50));
T(106) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50));
T(107) = (1-params(11))*T(1)*exp(T(1)*y(50));
T(108) = T(7)*T(107);
T(109) = params(30)^2;
T(110) = T(23)*y(68)+T(35)*y(21)*(-(T(26)*(-(exp(params(5)*y(11))*params(6)*exp(y(53))))))+T(35)*y(23)*T(26)*params(6)*params(5)*exp(y(53))*exp(y(11)*(params(5)-1));
T(111) = getPowerDeriv(T(39),params(5)-1,1);
T(112) = (-(exp(y(31))*exp(y(54))*params(6)*T(39)*T(111)));
T(113) = T(28)*T(112);
T(114) = (-(exp(y(31))*exp(y(54))*params(6)*T(111)*(-T(39))));
T(115) = T(28)*T(114);
T(116) = (-(exp(y(6))*exp(y(10))*(-exp((-y(62))))));
T(117) = (-(exp(y(6))*(-(exp(y(10))*(-exp((-y(62))))))));
T(118) = exp(y(6))*params(6)*exp(y(53))*exp(params(5)*(y(10)-y(62)))*(-params(5));
T(119) = y(68)*T(118);
T(120) = y(80)*T(116)+y(76)*T(117)+T(119);
T(121) = T(32)-exp(y(111))*(exp(y(103))-y(104));

end
